package easik.ui.menu;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.File;

import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;


import easik.Easik;


/**
 *	Menu action for opening and loading a sketch
 *  
 * @author Rob Fletcher 2005
 * @author Kevin Green 2006
 * @version 2006-08-03 Kevin Green
 */

public class FileOpenAction extends AbstractAction {	
	/**
	 * Create the menu option for loading a sketch	 
	 */
	public FileOpenAction() {
		super("Open Sketch...");
		putValue( AbstractAction.MNEMONIC_KEY,  new Integer(KeyEvent.VK_O));
		putValue( AbstractAction.SHORT_DESCRIPTION,  "Import an existing XML document as a sketch");		
	}
	
	/**
	 * Opens a new dialog box to choose the file to load.  Prompts user for confirmation if the current 
	 * sketch is unsaved.
	 * 
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e ) {
		int n = 0;
		if (Easik.getInstance().getFrame().getSketch().getDirty()) {
			n =
				JOptionPane.showConfirmDialog(
					Easik.getInstance().getFrame(),
					"Unsaved changes will be lost, continue anyway?",
					"Caution!",
					JOptionPane.YES_NO_OPTION);			
		}
		if (n != 0) {
			return;
		}
		
		
		JFileChooser loadDialog = new JFileChooser(Easik.getInstance().getIni().getDefaultFolder());
		loadDialog.addChoosableFileFilter( new XMLFileFilter() );		
		loadDialog.showOpenDialog( Easik.getInstance().getFrame() );		
		File selFile = loadDialog.getSelectedFile();
			
		if(selFile != null) {
			Easik.getInstance().getFrame().getSketch().loadFromXML( selFile );
			Easik.getInstance().getFrame().getSketch().setFile( selFile );
			Easik.getInstance().getIni().setLastUsedFolder( selFile.getAbsolutePath() );
			Easik.getInstance().getFrame().getSketch().setDirty(false);
			Easik.getInstance().getIni().addRecentFile(selFile);
		}
		
		
			
	}
}

